package tests;

import java.util.ArrayList;
import java.util.LinkedList;

import race.Operation;
import race.ProcessingTimeRace;
import race.Ranking;
import race.operations.ArrayListSortingWithBubbleSort;
import race.operations.ArrayListSortingWithCollectionsSort;
import race.operations.ListAdder;
import ui.RaceRankViewer;

public class Test001 {

	public static void main(String[] args) {
		ArrayList<Operation> listOperations = new ArrayList<Operation>();
		listOperations.add(new ListAdder(new ArrayList<Integer>(), "Element addition to an ArrayList<Integer>"));
		listOperations.add(new ArrayListSortingWithCollectionsSort());
		listOperations.add(new ArrayListSortingWithBubbleSort());
		listOperations.add(new ListAdder(new LinkedList<Integer>(), "Element addition to a LinkedList<Integer>"));
		ProcessingTimeRace race = new ProcessingTimeRace(listOperations, 100);
		for (Ranking placement : race.getRaceRank()) {
			System.out.println(placement.getContender()+"\t"+placement.getTime()+" ns");
		}
	}
}
